#!/bin/sh

# trackpoint-psmouse-bare: if no TrackPoint has been detected, reloads
# the psmouse kernel module.  Some Thinkpads fail to recognize the
# TrackPoint, and a module reload fixes it.

LOGFILE=/var/log/$(basename $0 .sh).log

echo "$(date +'%F %T') running" >> $LOGFILE

if ! dmesg | grep -q "TrackPoint"; then
    
    echo "$(date '+%F %T') reloading psmouse" >> $LOGFILE
    rmmod psmouse
    if [ "$(dmidecode -s system-version)" = "ThinkPad Edge E420s" ]; then
        modprobe psmouse proto=bare
    else
        modprobe psmouse
    fi
fi

echo "$(date '+%F %T') done" >> $LOGFILE
