/*
 * ubuntuone-nautilus.c - Nautilus extensions for Ubuntu One
 *
 * Authors: Tim Cole <tim.cole@canonical.com>
 *          Rodney Dawes <rodney.dawes@canonical.com>
 *          Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * Copyright 2009-2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __UBUNTUONE_NAUTILUS_H__
#define __UBUNTUONE_NAUTILUS_H__

#include <dbus/dbus-glib.h>
#include <libsyncdaemon/syncdaemon-daemon.h>
#include <gtk/gtk.h>
#include "file-watcher.h"

#define UBUNTUONE_TYPE_NAUTILUS  (ubuntuone_nautilus_get_type ())
#define UBUNTUONE_NAUTILUS(o)    (G_TYPE_CHECK_INSTANCE_CAST ((o), UBUNTUONE_TYPE_NAUTILUS, UbuntuOneNautilus))

/* This is used when a change is pending */
#define UPDATE_PENDING "pending"

struct _UbuntuOneNautilus {
	GObject parent_slot;

	SyncdaemonDaemon *syncdaemon;
	FileWatcher *file_watcher;

	/* Are we connected? */
	gboolean connected;

	/* The managed directory root */
	gchar * managed;

	/* Avoid calling get_rootdir and get_folders lots of times */
	gboolean gotroot;
	gboolean gotudfs;

	/* Lists of public files and user defined folders */
	GHashTable * public;
	GHashTable * udfs;
};

typedef struct {
	GObjectClass parent_slot;
} UbuntuOneNautilusClass;

GType ubuntuone_nautilus_get_type (void);

/* Utility functions */
gboolean ubuntuone_is_folder_shared (UbuntuOneNautilus *uon, const gchar *path);
gboolean ubuntuone_is_inside_shares (UbuntuOneNautilus *uon, const gchar *path);

gboolean ubuntuone_check_shares_and_public_files (UbuntuOneNautilus *uon,
							   SyncdaemonFolderInfo *folder_info,
							   GtkWidget *widget);
void     ubuntuone_show_error_dialog (UbuntuOneNautilus *uon, const gchar *title, const gchar *error_message, ...);

#endif
