#!/usr/bin/python

from aptsources.sourceslist import SourcesList
import apt_pkg
import sys

def test_sources_list():
    " test if the sources.list is parsable "
    try:
        apt_pkg.GetPkgSourceList()
    except SystemError, e:
        return False
    return True

def write_fresh_sources_list():
    " sources.list invalid, write blank one"
    open("/etc/apt/sources.list","w").write("""
""")

if __name__ == "__main__":
    
    # if sources.list is broken anyway, replace it and exit
    if not test_sources_list():
        write_fresh_sources_list()
        sys.exit(0)

    # rewrite existing one
    sources = SourcesList()
    sources.backup(".unr")

    # comment out the netbook-remix
    for entry in sources.list:
        if entry.disabled or entry.invalid:
            continue
        if entry.uri.startswith("http://netbook-remix.archive.canonical.com/ubuntu/"):
            entry.disabled=True

    # save and test if it is still parsable, revert backup if needed

    sources.save()
    if not test_sources_list():
        sources.restoreBackup(".unr")
