/* Copyright 2011 Canonical, Ltd. This software is licensed under the GNU
 * Lesser General Public License version 3 or later (see the file COPYING).
 */

#include "utouchpincharea.h"

#include "gestureevent.h"

UTouchPinchArea::UTouchPinchArea(QDeclarativeItem* parent)
  : ContinuousGestureArea(parent, kPinch)
{}

bool UTouchPinchArea::IsGestureEventHandled(GestureEvent* event) {
  GeisFloat radius =
    event->attributes().value(GEIS_GESTURE_ATTRIBUTE_RADIUS).toFloat();

  radius_.set(radius);

  return ContinuousGestureArea::IsGestureEventHandled(event) ||
         radius_.receivers(SIGNAL(initialChanged())) > 0 ||
         radius_.receivers(SIGNAL(currentChanged())) > 0;
}

void UTouchPinchArea::HandleGestureUpdateEvent(bool end, GestureEvent* event) {
  GeisFloat radius =
    event->attributes().value(GEIS_GESTURE_ATTRIBUTE_RADIUS).toFloat();

  radius_.update(radius);

  ContinuousGestureArea::HandleGestureUpdateEvent(end, event);
}
