/*
 * Copyright 2007-2008 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

package com.sun.tools.visualvm.modules.appui.keystore;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.spi.autoupdate.KeyStoreProvider;

/**
 *
 * @author Jiri Rechtacek
 * @author Tomas Hurka
 */
public final class VisualVMKeyStoreProvider implements KeyStoreProvider {
    
    public static final String KS_FILE_PATH = "ide.ks";
    private static final String KS_DEFAULT_PASSWORD = "open4all";
    
    public KeyStore getKeyStore() {
        KeyStore keyStore = null;
        InputStream is = null;
        
        try {
            is = getClass().getResourceAsStream(KS_FILE_PATH);
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load (is, KS_DEFAULT_PASSWORD.toCharArray());           
        } catch (Exception ex) {
            Logger.getLogger ("global").log(Level.INFO, ex.getMessage(), ex);
        } finally {
            try {
                if (is != null) is.close();
            } catch (IOException ex) {
                assert false : ex;
            }
        }
        return keyStore;
    }

}
