/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.office.OfficeStyle;
import writer2latex.office.PropertySet;
import writer2latex.util.Misc;

public class ListStyle
extends OfficeStyle {
    private static final int MAX_LEVEL = 10;
    private PropertySet[] level = new PropertySet[11];
    private PropertySet[] levelStyle = new PropertySet[11];

    public ListStyle() {
        int i = 1;
        while (i <= 10) {
            this.level[i] = new PropertySet();
            this.levelStyle[i] = new PropertySet();
            ++i;
        }
    }

    public String getLevelType(int i) {
        if (i >= 1 && i <= 10) {
            return this.level[i].getName();
        }
        return null;
    }

    public boolean isNumber(int i) {
        return "text:list-level-style-number".equals(this.level[i].getName());
    }

    public boolean isBullet(int i) {
        return "text:list-level-style-bullet".equals(this.level[i].getName());
    }

    public boolean isImage(int i) {
        return "text:list-level-style-image".equals(this.level[i].getName());
    }

    public String getLevelProperty(int i, String sName) {
        if (i >= 1 && i <= 10) {
            return this.level[i].getProperty(sName);
        }
        return null;
    }

    public String getLevelStyleProperty(int i, String sName) {
        if (i >= 1 && i <= 10) {
            return this.levelStyle[i].getProperty(sName);
        }
        return null;
    }

    public void loadStyleFromDOM(Node node) {
        super.loadStyleFromDOM(node);
        if (node.hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int nLen = nl.getLength();
            int i = 0;
            while (i < nLen) {
                int nLevel;
                String sLevel;
                Node child = nl.item(i);
                if (child.getNodeType() == 1 && (sLevel = Misc.getAttribute(child, "text:level")) != null && (nLevel = Misc.getPosInteger(sLevel, 1)) >= 1 && nLevel <= 10) {
                    this.level[nLevel].loadFromDOM(child);
                    if (child.hasChildNodes()) {
                        NodeList nl2 = child.getChildNodes();
                        int nLen2 = nl2.getLength();
                        int i2 = 0;
                        while (i2 < nLen2) {
                            Node child2 = nl2.item(i2);
                            if (child2.getNodeType() == 1) {
                                if (child2.getNodeName().equals("style:properties")) {
                                    this.levelStyle[nLevel].loadFromDOM(child2);
                                }
                                if (child2.getNodeName().equals("style:list-level-properties")) {
                                    this.levelStyle[nLevel].loadFromDOM(child2);
                                }
                            }
                            ++i2;
                        }
                    }
                }
                ++i;
            }
        }
    }

    static {
        MAX_LEVEL = 10;
    }
}

